<?php
// Public tracking page: /tracking.php?ref=SLUG

require __DIR__ . '/api/db.php';

// 1) Get record by slug (public ref)
$slug = $_GET['ref'] ?? '';
if (!$slug) { http_response_code(404); exit('Missing ref'); }

$stmt = $mysqli->prepare("SELECT * FROM tracking_pages WHERE slug = ? LIMIT 1");
$stmt->bind_param('s', $slug);
$stmt->execute();
$res = $stmt->get_result();
$row = $res->fetch_assoc();
if (!$row) { http_response_code(404); exit('Tracking not found'); }

// helpers
function money_sym($code) {
  $code = strtoupper((string)$code);
  return [
    'USD'=>'$', 'EUR'=>'€', 'GBP'=>'£', 'NGN'=>'₦', 'JPY'=>'¥', 'CNY'=>'¥', 'CAD'=>'C$', 'AUD'=>'A$'
  ][$code] ?? '$';
}
$amount   = number_format((float)$row['transfer_amount'], 2);
$fee      = number_format((float)$row['transfer_fee'], 2);
$progress = max(0, min(100, (int)$row['transfer_progress']));
$curr     = $row['currency'] ?: 'USD';
$sym      = money_sym($curr);
$maturity = $row['maturity_date'] ? date('M d, Y', strtotime($row['maturity_date'])) : '';

$flagCode = strtolower($row['country'] ?: 'us'); // show flag only

// status → css class
function pill_class($status) {
  $s = strtolower((string)$status);
  if (in_array($s, ['resolved','completed'])) return 'pill green';
  if (in_array($s, ['ongoing'])) return 'pill green';
  if (in_array($s, ['elapsing','pending'])) return 'pill yellow';
  if (in_array($s, ['failed','cancelled'])) return 'pill red';
  return 'pill gray';
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Tracking • WireTrf</title>

<link rel="icon" type="image/png" href="favicon.png">
<link rel="icon" type="image/png" sizes="32x32" href="favicon.png">
<link rel="icon" type="image/png" sizes="192x192" href="favicon.png">
<link rel="apple-touch-icon" href="favicon.png">
<link rel="shortcut icon" href="favicon.png">

<link rel="stylesheet" href="styles.css?v=<?php echo time(); ?>">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flag-icons@6.6.6/css/flag-icons.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">

<style>
/* Page frame */
.trk-page{background:#0A0F4D;min-height:100vh;font-family:'Poppins',sans-serif;color:#fff;}
.trk-wrap{max-width:960px;margin:0 auto;padding:36px 20px;}
/* header */
.trk-top{display:flex;justify-content:space-between;align-items:center;margin-bottom:18px}
.logo{height:42px}
.right-icons{display:flex;align-items:center;gap:14px}
.chat-ico{width:22px;height:22px;opacity:.9}
.flag{font-size:22px;line-height:1}
.time-chip{background:#FF8A00;color:#fff;border-radius:18px;padding:8px 14px;font-size:13px;display:inline-block}
/* greeting */
.greet h1{font-weight:400;margin:18px 0 8px 0;font-size:20px;color:#DDE1FF}
.greet h2{margin:0 0 8px 0;font-size:22px;color:#D7FF34;font-weight:600}
.greet .amt{font-size:34px;font-weight:700;margin:6px 0 18px 0}
/* card */
.card{background:#fff;color:#222;border-radius:16px;padding:26px;margin-top:18px;box-shadow:0 6px 22px rgba(0,0,0,.25)}
.row{display:grid;grid-template-columns:auto 1fr auto;gap:14px;align-items:center;margin:22px 0}
.dot{width:16px;height:16px;border-radius:50%;background:#0BA25E}
.row h3{margin:0;font-size:18px;font-weight:600}
.sub{margin:0;color:#555;font-size:13px}
.pill{padding:8px 16px;border-radius:10px;color:#fff;font-size:13px;text-align:center;min-width:96px}
.pill.green{background:#3DBE76}
.pill.yellow{background:#E4B43A;color:#222}
.pill.red{background:#E34B4B}
.pill.gray{background:#9BA3AF}
/* progress */
.progress-wrap{margin-top:8px}
.bar{height:10px;border-radius:6px;background:#D7D8DB;position:relative;overflow:hidden}

.pct{font-size:12px;color:#444;margin-top:6px;text-align:right}
/* footer logos (simple row placeholders) */
.pay-logos{display:flex;gap:26px;opacity:.85;align-items:center;justify-content:flex-start;margin:26px 0}
.pay-logos .badge{height:18px;width:56px;border-radius:4px;background:#2b2b2b}
.legal{font-size:11px;line-height:1.5;color:#D7D8F1;opacity:.9}
@media(max-width:700px){
  .trk-wrap{padding:24px 16px}
  .row{grid-template-columns:auto 1fr auto}
}
</style>
<?php
// decide bar color
$barColor = '#1F8E63'; // default green
$statusCheck = strtolower($row['billing_status']);
if (in_array($statusCheck, ['pending','failed','cancelled'])) {
    $barColor = '#E34B4B'; // red
}
?>
<style>
.bar > span{
  display:block;
  height:100%;
  background: <?php echo $barColor; ?>;
  width: <?php echo $progress; ?>%;
}
</style>

</head>
<body class="trk-page">
  <div class="trk-wrap">
    <!-- top bar -->
    <div class="trk-top">
      <img src="assets/logo.png" class="logo" alt="WireTrf">
      <div class="right-icons">
        <!-- chat icon (visual only) -->
        <svg class="chat-ico" viewBox="0 0 24 24" fill="none"><path d="M4 5h16v10H7l-3 3V5z" stroke="#fff" stroke-width="2" stroke-linejoin="round"/></svg>
        <!-- flag only -->
        <span class="flag fi fi-<?php echo htmlspecialchars($flagCode); ?>"></span>
      </div>
    </div>

    <!-- time chip -->
    <div style="display:flex;justify-content:flex-end;margin-bottom:8px;">
      <span class="time-chip"><?php echo htmlspecialchars($maturity); ?></span>

    </div>

    <!-- greeting -->
    <div class="greet">
      <h1>Hello <?php echo htmlspecialchars($row['recipient']); ?>,</h1>
      <h2><?php echo htmlspecialchars($row['sender']); ?> is sending you</h2>
      <div class="amt"><?php echo $sym . $amount; ?></div>
      <div style="height:1px;background:#5e63b0;opacity:.4;margin:12px 0 6px;"></div>
    </div>

    <!-- main card -->
    <div class="card">

      <!-- Row 1 -->
      <div class="row">
        <span class="dot"></span>
        <div>
          <h3><?php echo htmlspecialchars($row['sender']); ?> made a <?php echo $sym . $amount; ?> transfer</h3>
          <div class="progress-wrap">
            <div class="bar"><span></span></div>
            <div class="pct"><?php echo $progress; ?>%</div>
          </div>
        </div>
        <div class="<?php echo pill_class($row['billing_status']); ?>">
          <?php echo htmlspecialchars($row['billing_status']); ?>
        </div>
      </div>

      <!-- Row 2 -->
      <div class="row">
        <span class="dot"></span>
        <div>
          <h3>Foreign Transaction Fees</h3>
          <p class="sub"> <?php
              $msg = trim((string)$row['billing']);
              if ($msg === '') $msg = 'Your money is on its way.';
              echo htmlspecialchars($msg);
            ?></p>
        </div>
        <div class="<?php echo pill_class($row['transfer_fee_status']); ?>">
          <?php echo htmlspecialchars($row['transfer_fee_status']); ?>
        </div>
      </div>

      <!-- Row 3 -->
      <div class="row">
        <span class="dot"></span>
        <div>
          <h3>Maturity Date</h3>
          <p class="sub">
            <?php
              $msg = trim((string)$row['maturity_message']);
              if ($msg === '') $msg = 'We apologize for any inconvenience you may have experienced. Please note that the time is elapsing. Thank you for selecting our bank for your financial needs.';
              echo htmlspecialchars($msg);
            ?>
          </p>
        </div>
        <div class="<?php echo pill_class($row['maturity_status']); ?>">
          <?php echo htmlspecialchars($row['maturity_status']); ?>
        </div>
      </div>

    </div>

    <!-- brand strip (simple placeholders; swap with SVGs when ready) -->
    <div class="pay-logos">
    <img src="assets/visa.png" alt="Visa">
    <img src="assets/mastercard.png" alt="Mastercard">
    <img src="assets/maestro.png" alt="Maestro">
    <img src="assets/paypal.png" alt="PayPal">
    <img src="assets/amex.png" alt="American Express">
</div>



    <!-- legal -->
    <div class="legal">
      TransferGo is an authorised electronic money institution (EMI) authorized by the Financial Conduct Authority (FCA) under the Electronic Money regulations 2011 (EMRs) and the payment Services Regulations 2017 (PSRS) (Firm registration number: 994948) to issue electronic money and providing payment services. Our registered office is 1a Old Street Yard, White Collar Factory, EC1Y 8AF, London, United Kingdom. <br> <br>
TransferGo Lithuania UAB is an electronic money Institution established in the Republic of Lithuania, authorised and regulated by the Bank of Lithuania. Registered address: Palangos str. 4. Vilnius Lithuania, number of registration 39448393325, FI Code 36282. Our registered office is 1a Old Street Yard, White Collar Factory, EC1Y 8AF, London, United Kingdom.<br> <br>
Copyright 2025 TransferGo Ltd.
    </div>

  </div>
</body>
</html>
