-- USERS
CREATE TABLE users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  email VARCHAR(255) UNIQUE NOT NULL,
  password_hash VARCHAR(255) NOT NULL,
  name VARCHAR(255) DEFAULT NULL,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP
);

-- TRACKING PAGES (Main Table)
CREATE TABLE tracking_pages (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  slug VARCHAR(100) UNIQUE NOT NULL,
  sender VARCHAR(255) NOT NULL,
  recipient VARCHAR(255) NOT NULL,
  recipient_email VARCHAR(255) NOT NULL,
  country VARCHAR(100) DEFAULT NULL,
  currency VARCHAR(10) DEFAULT 'USD',
  transfer_amount DECIMAL(12,2) NOT NULL,
  transfer_fee DECIMAL(12,2) DEFAULT 0.00,
  transfer_progress INT DEFAULT 0,
  transfer_status ENUM('Pending','Ongoing','Resolved','Failed') DEFAULT 'Pending',
  transfer_fee_status ENUM('Pending','Resolved','Failed') DEFAULT 'Pending',
  maturity_date DATE DEFAULT NULL,
  maturity_status ENUM('Ongoing','Elapsing','Completed') DEFAULT 'Ongoing',
  maturity_message TEXT DEFAULT NULL,
  billing VARCHAR(255) DEFAULT NULL,
  billing_status ENUM('Pending','Resolved','Cancelled') DEFAULT 'Pending',
  extra_info TEXT DEFAULT NULL,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

-- TRACKING UPDATES (optional timeline)
CREATE TABLE tracking_updates (
  id INT AUTO_INCREMENT PRIMARY KEY,
  tracking_page_id INT NOT NULL,
  status VARCHAR(255),
  note TEXT,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (tracking_page_id) REFERENCES tracking_pages(id) ON DELETE CASCADE
);
