<?php
// =============================
// WireTrf - Login Page
// =============================

// connect to database
require __DIR__ . '/api/db.php';
session_start();

$err = '';

// handle login form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if (!filter_var($email, FILTER_VALIDATE_EMAIL) || strlen($password) < 1) {
        $err = 'Please enter valid credentials.';
    } else {
        $stmt = $mysqli->prepare('SELECT id, password_hash FROM users WHERE email = ? LIMIT 1');
        $stmt->bind_param('s', $email);
        $stmt->execute();
        $res = $stmt->get_result();

        if ($row = $res->fetch_assoc()) {
            if (password_verify($password, $row['password_hash'])) {
                // login success
                $_SESSION['user_id'] = $row['id'];
                header('Location: dashboard.php');
                exit;
            } else {
                $err = 'Invalid email or password.';
            }
        } else {
            $err = 'Invalid email or password.';
        }
    }
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>WireTrf — Login</title>
<link rel="stylesheet" href="styles.css">
</head>
<body class="page-login">
  <main class="login-wrap">
    <div class="login-card">
      <img src="assets/logo.png" alt="WireTrf logo" class="logo-small" />
      <h1 class="login-title">Welcome Family</h1>

      <?php if($err): ?>
        <div class="alert"><?php echo htmlspecialchars($err); ?></div>
      <?php endif; ?>

      <form method="post" class="login-form" autocomplete="off">
        <input name="email" type="text" placeholder="Username / Email" required />
        <input name="password" type="password" placeholder="Password" required />
        <button class="btn-primary" type="submit">Login</button>
      </form>
    </div>
  </main>
<script src="scripts.js"></script>
</body>
</html>
