<?php
require __DIR__.'/api/auth.php';
require_login();
require __DIR__.'/api/db.php';

// Fetch all tracking pages for the logged-in user
$stmt = $mysqli->prepare("SELECT * FROM tracking_pages WHERE user_id = ? ORDER BY id DESC");
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$res = $stmt->get_result();
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>List of Tracking Pages</title>
<link rel="stylesheet" href="styles.css?v=<?php echo time(); ?>">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
<style>
body { background:#0A0F4D; color:white; font-family:'Poppins',sans-serif; }

.table-container {
  background:white;
  color:#111;
  width:90%;
  max-width:1000px;
  margin:60px auto;
  padding:25px;
  border-radius:18px;
  box-shadow:0 0 25px rgba(0,0,0,0.35);
}

table { width:100%; border-collapse:collapse; }
th {
  text-align:left; padding:14px;
  font-weight:600; font-size:15px;
  background:#1b1f6d; color:white;
}
td { padding:12px; font-size:14px; }

tr:nth-child(even){ background:#f1f1f1; }
tr:nth-child(odd){ background:#ffffff; }

.copy-btn {
  color:#1a38c2; cursor:pointer; text-decoration:underline;
}

.edit-btn {
  color:#0474ff; text-decoration:none; font-weight:500;
}

.delete-btn {
  background:#e84444; color:white;
  padding:6px 10px; border-radius:6px;
  text-decoration:none; font-size:13px;
}

/* center page title */
.page-title {text-align:center; margin-top:40px; font-size:22px; font-weight:500;}
.home-btn {
  display:inline-block;
  padding:10px 18px;
  background:#FF7A00;
  border-radius:8px;
  color:#fff;
  font-weight:500;
  text-decoration:none;
}
.home-btn:hover { opacity:.9; }

</style>
</head>
<body>
    

<h2 class="page-title">List of Clients</h2>

<div class="table-container">
<table>
<thead>
<tr>
<th>#</th>
<th>Sender</th>
<th>Recipient</th>
<th>Tracking Link</th>
<th>Details</th>
</tr>
</thead>
<tbody>

<?php
$count = 1;
while($row = $res->fetch_assoc()):
$link = "https://".$_SERVER['SERVER_NAME']."/tracking.php?ref=".$row['slug'];
?>
<tr>
<td><?php echo $count++; ?></td>
<td><?php echo htmlspecialchars($row['sender']); ?></td>
<td><?php echo htmlspecialchars($row['recipient']); ?></td>

<!-- Copy Link Button -->
<td><span class="copy-btn" onclick="copyLink('<?php echo $link; ?>')">Copy Link</span></td>

<td>
  <a class="edit-btn" href="edit_tracking.php?id=<?php echo $row['id']; ?>">Edit Details</a>
  &nbsp;&nbsp;
  <a class="delete-btn" href="#" onclick="confirmDelete(<?php echo $row['id']; ?>)">Delete</a>
</td>
</tr>
<?php endwhile; ?>

</tbody>
</table>
</div>
<div class="top-nav">
  <a href="dashboard.php" class="home-btn">← Back to Home</a>
</div>


<script>
// Copy link to clipboard
function copyLink(link){
  navigator.clipboard.writeText(link);
  alert("Tracking Link Copied:\n" + link);
}

// Confirm delete before sending
function confirmDelete(id){
  if(confirm("Are you sure you want to delete this tracking page? This cannot be undone.")){
    window.location = "delete_tracking.php?id=" + id;
  }
}
</script>

</body>
</html>
