<?php
require __DIR__.'/api/auth.php';
require_login();
require __DIR__.'/api/db.php';

if(!isset($_GET['id'])){
    header("Location: list_tracking.php");
    exit;
}

$id = intval($_GET['id']);

// Fetch record
$stmt = $mysqli->prepare("SELECT * FROM tracking_pages WHERE id = ? AND user_id = ?");
$stmt->bind_param("ii", $id, $_SESSION['user_id']);
$stmt->execute();
$res = $stmt->get_result();
$row = $res->fetch_assoc();
if(!$row){
    exit("Record not found");
}

$success = $error = "";

// When form submitted
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $stmt = $mysqli->prepare("UPDATE tracking_pages SET
    sender=?, recipient=?, recipient_email=?, transfer_amount=?, transfer_fee=?, transfer_progress=?,
    transfer_fee_status=?, maturity_date=?, maturity_status=?, maturity_message=?, country=?, billing=?,
    billing_status=?, currency=? 
    WHERE id=? AND user_id=?");

$stmt->bind_param("sssddissssssssii",
    $_POST['sender'],
    $_POST['recipient'],
    $_POST['recipient_email'],
    $_POST['transfer_amount'],
    $_POST['transfer_fee'],
    $_POST['transfer_progress'],
    $_POST['transfer_fee_status'],
    $_POST['maturity_date'],
    $_POST['maturity_status'],
    $_POST['maturity_message'],
    $_POST['country'],
    $_POST['billing'],
    $_POST['billing_status'],
    $_POST['currency'],
    $id,
    $_SESSION['user_id']
);


    if($stmt->execute()){
        $success = "Details Updated Successfully";
        // Refresh $row with updated values
        $row = array_merge($row, $_POST);
    } else {
        $error = "Something went wrong. Try again.";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Edit Details</title>
<link rel="stylesheet" href="styles.css?v=<?php echo time(); ?>">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
<style>
body { background:#E9ECF8; font-family:'Poppins',sans-serif; }
.form-wrapper {
  background:white; width:90%; max-width:850px; margin:50px auto; padding:45px;
  border-radius:22px; box-shadow:0 0 30px rgba(0,0,0,0.12);
}
.form-wrapper h2 { margin-bottom:10px; }
label { display:block; margin-top:12px; font-weight:500; }
input, select {
  width:100%; padding:12px; border-radius:8px; border:1px solid #ccc; margin-top:5px;
}

/* Blue selects */
select { background:#001CFF; color:white; border:none; }

.buttons { margin-top:25px; display:flex; gap:14px; }
.btn-save { background:#0074FF; color:white; padding:12px 28px; border-radius:8px; border:none; }
.btn-close { padding:12px 28px; border-radius:8px; background:#bbb; color:black; text-decoration:none; }
.alert { padding:12px; border-radius:6px; margin:12px 0; }
.success{ background:#d7ffe0; color:#135d25; }
.error{ background:#ffe0e0; color:#8a1e1e; }
</style>
</head>
<body>

<div class="form-wrapper">
<h2>Edit Details</h2>
<hr>

<?php if($success): ?><div class="alert success"><?php echo $success; ?></div><?php endif; ?>
<?php if($error): ?><div class="alert error"><?php echo $error; ?></div><?php endif; ?>

<form method="post">
<label>Sender</label>
<input type="text" name="sender" value="<?php echo $row['sender']; ?>" required>

<label>Recipient</label>
<input type="text" name="recipient" value="<?php echo $row['recipient']; ?>" required>

<label>Recipient Email</label>
<input type="email" name="recipient_email" value="<?php echo $row['recipient_email']; ?>" required>

<label>Transfer Amount</label>
<input type="number" step="0.01" name="transfer_amount" value="<?php echo $row['transfer_amount']; ?>">

<label>Transfer Fee</label>
<input type="number" step="0.01" name="transfer_fee" value="<?php echo $row['transfer_fee']; ?>">

<label>Transfer Progress (%)</label>
<input type="number" name="transfer_progress" value="<?php echo $row['transfer_progress']; ?>">

<label>Transfer Fee Status</label>
<select name="transfer_fee_status">
<option <?php if($row['transfer_fee_status']=="Pending") echo "selected"; ?>>Pending</option>
<option <?php if($row['transfer_fee_status']=="Resolved") echo "selected"; ?>>Resolved</option>
<option <?php if($row['transfer_fee_status']=="Failed") echo "selected"; ?>>Failed</option>
</select>

<label>Maturity Date</label>
<input type="date" name="maturity_date" value="<?php echo $row['maturity_date']; ?>">

<label>Maturity Date Status</label>
<select name="maturity_status">
<option <?php if($row['maturity_status']=="Ongoing") echo "selected"; ?>>Ongoing</option>
<option <?php if($row['maturity_status']=="Elapsing") echo "selected"; ?>>Elapsing</option>
<option <?php if($row['maturity_status']=="Completed") echo "selected"; ?>>Completed</option>
</select>

<label>Maturity Message</label>
<input type="text" name="maturity_message" value="<?php echo $row['maturity_message']; ?>">

<label>Country</label>
<select name="country">
<option value="<?php echo $row['country']; ?>" selected>Current (<?php echo $row['country']; ?>)</option>
<?php include __DIR__.'/country_options.php'; ?>
</select>

<label>Billing</label>
<input type="text" name="billing" value="<?php echo $row['billing']; ?>">

<label>Billing Status</label>
<select name="billing_status">
<option <?php if($row['billing_status']=="Pending") echo "selected"; ?>>Pending</option>
<option <?php if($row['billing_status']=="Resolved") echo "selected"; ?>>Resolved</option>
<option <?php if($row['billing_status']=="Cancelled") echo "selected"; ?>>Cancelled</option>
</select>

<label>Currency</label>
<select name="currency">
<option <?php if($row['currency']=="USD") echo "selected"; ?>>USD</option>
<option <?php if($row['currency']=="EUR") echo "selected"; ?>>EUR</option>
<option <?php if($row['currency']=="GBP") echo "selected"; ?>>GBP</option>
<option <?php if($row['currency']=="NGN") echo "selected"; ?>>NGN</option>
</select>

<div class="buttons">
<button class="btn-save" type="submit">✔ Save</button>
<a href="list_tracking.php" class="btn-close">✖ Close</a>
</div>
</form>
</div>

</body>
</html>
