<?php
require __DIR__ . '/api/auth.php';
require_login();
require __DIR__ . '/api/db.php';

$success = $error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // generate random slug
    $slug = substr(str_shuffle("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"), 0, 10);

    $stmt = $mysqli->prepare("INSERT INTO tracking_pages 
        (user_id, slug, sender, recipient, recipient_email, transfer_amount, transfer_fee, transfer_progress, transfer_fee_status, maturity_date, maturity_status, maturity_message, country, billing, billing_status, currency) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    $stmt->bind_param("issssddissssssss",
        $_SESSION['user_id'],
        $slug,
        $_POST['sender'],
        $_POST['recipient'],
        $_POST['recipient_email'],
        $_POST['transfer_amount'],
        $_POST['transfer_fee'],
        $_POST['transfer_progress'],
        $_POST['transfer_fee_status'],
        $_POST['maturity_date'],
        $_POST['maturity_status'],
        $_POST['maturity_message'],
        $_POST['country'],
        $_POST['billing'],
        $_POST['billing_status'],
        $_POST['currency']
    );

    if ($stmt->execute()) {
        $success = "Billing Created Successfully!";
    } else {
        $error = "Error saving record.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Create Billing</title>
<link rel="stylesheet" href="styles.css?v=<?php echo time(); ?>">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flag-icons@6.6.6/css/flag-icons.min.css">

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500&display=swap" rel="stylesheet">
</head>
<body class="form-page">

<div class="form-wrapper">
    <h2>Create Billing</h2>
    <div class="form-line"></div>

    <?php if($success): ?>
        <div class="alert success"><?php echo $success; ?></div>
    <?php endif; ?>

    <?php if($error): ?>
        <div class="alert error"><?php echo $error; ?></div>
    <?php endif; ?>

    <form method="post">

        <label>Sender</label>
        <input type="text" name="sender" required>

        <label>Recipient</label>
        <input type="text" name="recipient" required>

        <label>Recipient Email</label>
        <input type="email" name="recipient_email" required>

        <label>Transfer Amount</label>
        <input type="number" step="0.01" name="transfer_amount" required>

        <label>Transfer Fee</label>
        <input type="number" step="0.01" name="transfer_fee">

        <label>Transfer Progress (%)</label>
        <input type="number" name="transfer_progress" required>

        <label>Transfer Fee Status</label>
        <select name="transfer_fee_status">
            <option>Pending</option>
            <option>Resolved</option>
            <option>Failed</option>
        </select>

        <label>Maturity Date</label>
        <input type="date" name="maturity_date">

        <label>Maturity Date Status</label>
        <select name="maturity_status">
            <option>Ongoing</option>
            <option>Elapsing</option>
            <option>Completed</option>
        </select>

        <label>Maturity Message</label>
        <input type="text" name="maturity_message">

        <label>Country</label>
        <select name="country">
            <option value="af">🇦🇫 Afghanistan</option>
<option value="al">🇦🇱 Albania</option>
<option value="dz">🇩🇿 Algeria</option>
<option value="ad">🇦🇩 Andorra</option>
<option value="ao">🇦🇴 Angola</option>
<option value="ag">🇦🇬 Antigua & Barbuda</option>
<option value="ar">🇦🇷 Argentina</option>
<option value="am">🇦🇲 Armenia</option>
<option value="au">🇦🇺 Australia</option>
<option value="at">🇦🇹 Austria</option>
<option value="az">🇦🇿 Azerbaijan</option>
<option value="bs">🇧🇸 Bahamas</option>
<option value="bh">🇧🇭 Bahrain</option>
<option value="bd">🇧🇩 Bangladesh</option>
<option value="bb">🇧🇧 Barbados</option>
<option value="by">🇧🇾 Belarus</option>
<option value="be">🇧🇪 Belgium</option>
<option value="bz">🇧🇿 Belize</option>
<option value="bj">🇧🇯 Benin</option>
<option value="bt">🇧🇹 Bhutan</option>
<option value="bo">🇧🇴 Bolivia</option>
<option value="ba">🇧🇦 Bosnia & Herzegovina</option>
<option value="bw">🇧🇼 Botswana</option>
<option value="br">🇧🇷 Brazil</option>
<option value="bn">🇧🇳 Brunei</option>
<option value="bg">🇧🇬 Bulgaria</option>
<option value="bf">🇧🇫 Burkina Faso</option>
<option value="bi">🇧🇮 Burundi</option>
<option value="kh">🇰🇭 Cambodia</option>
<option value="cm">🇨🇲 Cameroon</option>
<option value="ca">🇨🇦 Canada</option>
<option value="cv">🇨🇻 Cape Verde</option>
<option value="cf">🇨🇫 Central African Republic</option>
<option value="td">🇹🇩 Chad</option>
<option value="cl">🇨🇱 Chile</option>
<option value="cn">🇨🇳 China</option>
<option value="co">🇨🇴 Colombia</option>
<option value="km">🇰🇲 Comoros</option>
<option value="cg">🇨🇬 Congo - Brazzaville</option>
<option value="cd">🇨🇩 Congo - Kinshasa</option>
<option value="cr">🇨🇷 Costa Rica</option>
<option value="hr">🇭🇷 Croatia</option>
<option value="cu">🇨🇺 Cuba</option>
<option value="cy">🇨🇾 Cyprus</option>
<option value="cz">🇨🇿 Czech Republic</option>
<option value="dk">🇩🇰 Denmark</option>
<option value="dj">🇩🇯 Djibouti</option>
<option value="dm">🇩🇲 Dominica</option>
<option value="do">🇩🇴 Dominican Republic</option>
<option value="ec">🇪🇨 Ecuador</option>
<option value="eg">🇪🇬 Egypt</option>
<option value="sv">🇸🇻 El Salvador</option>
<option value="gq">🇬🇶 Equatorial Guinea</option>
<option value="er">🇪🇷 Eritrea</option>
<option value="ee">🇪🇪 Estonia</option>
<option value="sz">🇸🇿 Eswatini</option>
<option value="et">🇪🇹 Ethiopia</option>
<option value="fj">🇫🇯 Fiji</option>
<option value="fi">🇫🇮 Finland</option>
<option value="fr">🇫🇷 France</option>
<option value="ga">🇬🇦 Gabon</option>
<option value="gm">🇬🇲 Gambia</option>
<option value="ge">🇬🇪 Georgia</option>
<option value="de">🇩🇪 Germany</option>
<option value="gh">🇬🇭 Ghana</option>
<option value="gr">🇬🇷 Greece</option>
<option value="gd">🇬🇩 Grenada</option>
<option value="gt">🇬🇹 Guatemala</option>
<option value="gn">🇬🇳 Guinea</option>
<option value="gw">🇬🇼 Guinea-Bissau</option>
<option value="gy">🇬🇾 Guyana</option>
<option value="ht">🇭🇹 Haiti</option>
<option value="hn">🇭🇳 Honduras</option>
<option value="hu">🇭🇺 Hungary</option>
<option value="is">🇮🇸 Iceland</option>
<option value="in">🇮🇳 India</option>
<option value="id">🇮🇩 Indonesia</option>
<option value="ir">🇮🇷 Iran</option>
<option value="iq">🇮🇶 Iraq</option>
<option value="ie">🇮🇪 Ireland</option>
<option value="il">🇮🇱 Israel</option>
<option value="it">🇮🇹 Italy</option>
<option value="jm">🇯🇲 Jamaica</option>
<option value="jp">🇯🇵 Japan</option>
<option value="jo">🇯🇴 Jordan</option>
<option value="kz">🇰🇿 Kazakhstan</option>
<option value="ke">🇰🇪 Kenya</option>
<option value="kw">🇰🇼 Kuwait</option>
<option value="kg">🇰🇬 Kyrgyzstan</option>
<option value="la">🇱🇦 Laos</option>
<option value="lv">🇱🇻 Latvia</option>
<option value="lb">🇱🇧 Lebanon</option>
<option value="ls">🇱🇸 Lesotho</option>
<option value="lr">🇱🇷 Liberia</option>
<option value="ly">🇱🇾 Libya</option>
<option value="lt">🇱🇹 Lithuania</option>
<option value="lu">🇱🇺 Luxembourg</option>
<option value="mg">🇲🇬 Madagascar</option>
<option value="mw">🇲🇼 Malawi</option>
<option value="my">🇲🇾 Malaysia</option>
<option value="ml">🇲🇱 Mali</option>
<option value="mt">🇲🇹 Malta</option>
<option value="mr">🇲🇷 Mauritania</option>
<option value="mu">🇲🇺 Mauritius</option>
<option value="mx">🇲🇽 Mexico</option>
<option value="md">🇲🇩 Moldova</option>
<option value="mc">🇲🇨 Monaco</option>
<option value="mn">🇲🇳 Mongolia</option>
<option value="ma">🇲🇦 Morocco</option>
<option value="mz">🇲🇿 Mozambique</option>
<option value="mm">🇲🇲 Myanmar</option>
<option value="na">🇳🇦 Namibia</option>
<option value="np">🇳🇵 Nepal</option>
<option value="nl">🇳🇱 Netherlands</option>
<option value="nz">🇳🇿 New Zealand</option>
<option value="ni">🇳🇮 Nicaragua</option>
<option value="ne">🇳🇪 Niger</option>
<option value="ng">🇳🇬 Nigeria</option>
<option value="kp">🇰🇵 North Korea</option>
<option value="no">🇳🇴 Norway</option>
<option value="om">🇴🇲 Oman</option>
<option value="pk">🇵🇰 Pakistan</option>
<option value="pa">🇵🇦 Panama</option>
<option value="pg">🇵🇬 Papua New Guinea</option>
<option value="py">🇵🇾 Paraguay</option>
<option value="pe">🇵🇪 Peru</option>
<option value="ph">🇵🇭 Philippines</option>
<option value="pl">🇵🇱 Poland</option>
<option value="pt">🇵🇹 Portugal</option>
<option value="qa">🇶🇦 Qatar</option>
<option value="ro">🇷🇴 Romania</option>
<option value="ru">🇷🇺 Russia</option>
<option value="rw">🇷🇼 Rwanda</option>
<option value="sa">🇸🇦 Saudi Arabia</option>
<option value="sn">🇸🇳 Senegal</option>
<option value="rs">🇷🇸 Serbia</option>
<option value="sc">🇸🇨 Seychelles</option>
<option value="sl">🇸🇱 Sierra Leone</option>
<option value="sg">🇸🇬 Singapore</option>
<option value="sk">🇸🇰 Slovakia</option>
<option value="si">🇸🇮 Slovenia</option>
<option value="so">🇸🇴 Somalia</option>
<option value="za">🇿🇦 South Africa</option>
<option value="kr">🇰🇷 South Korea</option>
<option value="es">🇪🇸 Spain</option>
<option value="lk">🇱🇰 Sri Lanka</option>
<option value="sd">🇸🇩 Sudan</option>
<option value="se">🇸🇪 Sweden</option>
<option value="ch">🇨🇭 Switzerland</option>
<option value="sy">🇸🇾 Syria</option>
<option value="tw">🇹🇼 Taiwan</option>
<option value="tz">🇹🇿 Tanzania</option>
<option value="th">🇹🇭 Thailand</option>
<option value="tg">🇹🇬 Togo</option>
<option value="tt">🇹🇹 Trinidad & Tobago</option>
<option value="tn">🇹🇳 Tunisia</option>
<option value="tr">🇹🇷 Turkey</option>
<option value="ug">🇺🇬 Uganda</option>
<option value="ua">🇺🇦 Ukraine</option>
<option value="ae">🇦🇪 United Arab Emirates</option>
<option value="gb">🇬🇧 United Kingdom</option>
<option value="us">🇺🇸 United States</option>
<option value="uy">🇺🇾 Uruguay</option>
<option value="ve">🇻🇪 Venezuela</option>
<option value="vn">🇻🇳 Vietnam</option>
<option value="zm">🇿🇲 Zambia</option>
<option value="zw">🇿🇼 Zimbabwe</option>

        </select>

        <label>Billing</label>
        <input type="text" name="billing">

        <label>Billing Status</label>
        <select name="billing_status">
            <option>Pending</option>
            <option>Resolved</option>
            <option>Cancelled</option>
        </select>

        <label>Currency</label>
        <select name="currency">
            <option>USD</option>
            <option>EUR</option>
            <option>GBP</option>
            <option>NGN</option>
        </select>

        <div class="form-buttons">
            <button class="btn-save" type="submit">✔ Save</button>
            <a href="dashboard.php" class="btn-close">✖ Close</a>
        </div>

    </form>
</div>

</body>
</html>
