<?php
require __DIR__.'/api/auth.php';
require_login();
require __DIR__.'/api/db.php';

$success = $error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $old = $_POST['old_password'];
    $new = $_POST['new_password'];

    // Get current hashed password
    $stmt = $mysqli->prepare("SELECT password_hash FROM users WHERE id = ?");
    $stmt->bind_param("i", $_SESSION['user_id']);
    $stmt->execute();
    $res = $stmt->get_result();
    $user = $res->fetch_assoc();

    if (!$user) {
        $error = "User not found.";
    } elseif (!password_verify($old, $user['password_hash'])) {
        $error = "Old password is incorrect.";
    } else {
        // Update to new password hash
        $newHash = password_hash($new, PASSWORD_DEFAULT);

        $stmt = $mysqli->prepare("UPDATE users SET password_hash=? WHERE id=?");
        $stmt->bind_param("si", $newHash, $_SESSION['user_id']);
        $stmt->execute();

        $success = "Password changed successfully.";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Change Password</title>
<link rel="stylesheet" href="styles.css?v=<?php echo time(); ?>">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">

<style>
body {
  background: #E9ECF8;
  font-family: 'Poppins', sans-serif;
}

.box {
  background: #FF7A00;
  width: 90%;
  max-width: 450px;
  margin: 90px auto;
  padding: 55px 40px;
  border-radius: 35px;
  text-align: center;
  color: #2D0066;
}

.box input {
  width: 100%;
  padding: 14px;
  border-radius: 12px;
  border: none;
  margin-top: 18px;
  outline: none;
  font-size: 15px;
}

.btn {
  margin-top: 30px;
  display: block;
  width: 100%;
  background: #3A008D;
  color: white;
  padding: 14px;
  border-radius: 14px;
  border: none;
  cursor: pointer;
  font-size: 16px;
}

.alert {
  background: white;
  padding: 12px;
  margin-top: 14px;
  border-radius: 8px;
  font-size: 14px;
}
.success { color: green; }
.error { color: red; }
</style>
</head>

<body>

<div class="box">
  <img src="assets/logo.png" alt="WireTrf" style="height:45px;margin-bottom:18px;">
  <h2>Change Password</h2>

  <?php if($success): ?>
  <div class="alert success"><?php echo $success; ?></div>
  <?php endif; ?>

  <?php if($error): ?>
  <div class="alert error"><?php echo $error; ?></div>
  <?php endif; ?>

  <form method="post">
    <input type="password" name="old_password" placeholder="Old Password" required>
    <input type="password" name="new_password" placeholder="New Password" required>
    <button class="btn" type="submit">Change Password</button>
  </form>

  <br>
  <a href="dashboard.php" style="text-decoration:none;color:#2D0066;">← Back to Dashboard</a>
</div>

</body>
</html>
