<?php
// api/auth.php
require __DIR__ . '/db.php';
session_start();

function require_login() {
    if (empty($_SESSION['user_id'])) {
        header('Location: /login.php');
        exit;
    }
}

// call to check login and fetch user
function current_user() {
    global $mysqli;
    if (empty($_SESSION['user_id'])) return null;
    $id = (int)$_SESSION['user_id'];
    $stmt = $mysqli->prepare('SELECT id, email, name FROM users WHERE id = ? LIMIT 1');
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $res = $stmt->get_result();
    return $res->fetch_assoc();
}
